﻿using System;
using System.Xml;
using System.Xml.Linq;
using WcfServiceClient.ServiceReferenceLists;

namespace WcfServiceClient
{
   public static class Extension
   {
      public static XmlNode GetXmlNode(this XElement element)
      {
         using (XmlReader xmlReader = element.CreateReader())
         {
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.Load(xmlReader);
            return xmlDoc;
         }
      }
   }

   class Program
   {
      static void Main(string[] args)
      {
         ListsSoapClient client = new ListsSoapClient();

         try
         {
            client.Open();

            Console.WriteLine("Verbindung erfolgreich aufgebaut!");

            // Service-Methode aufrufen
            var response = client.GetListCollection();

            // Extension Methode aufrufen und Daten transformieren
            XmlNode node = response.GetXmlNode();

            // Daten iterieren (<Lists><List> ... </List></Lists>)
            foreach (XmlNode n in node.ChildNodes[0])
            {
               string title = n.Attributes["Title"].Value;
               string description = n.Attributes["Description"].Value;
               Console.WriteLine("{0} \n{1}\n", title, description);
            }
         }
         catch (Exception exc)
         {
            Console.ForegroundColor = ConsoleColor.Red;
            Console.WriteLine("\nFehler beim Serviceaufruf! \n\n{0}",
               exc.Message);
         }
      }
   }
}